#ifndef __DM_NUTYPEDEFS_H__
#define __DM_NUTYPEDEFS_H__

//This definition uses DM heartbeat LED for lock time measurements
//#define DM_LOCK_TIME_TEST   1

#ifdef DM_LINUX

//DMCards don't have Nucleus so add definitions
#ifndef UNSIGNED
typedef unsigned long           UNSIGNED;
#endif

#ifndef SIGNED
typedef long                    SIGNED;
#endif

#ifndef U32
typedef unsigned long           U32;
#endif

#endif

#if defined(DMCARDS_BUILD) || defined(DM_LINUX) || defined(DM_WINCE)

#ifndef LITTLE_ENDIAN
 #define LITTLE_ENDIAN               1
#endif

#else

#ifndef BIG_ENDIAN
  #define BIG_ENDIAN                  1
#endif

#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef DM_VPG
//
// use windows types for CE
//
#include <windef.h>
#include <winnt.h>
#include <types.h>
//

#elif defined(DM_WINCE)

#include <windef.h>     //Taken from DM_VPG
#include <winnt.h>      //Taken from DM_VPG
#include <winbase.h>    //Taken from CrestCeOs.cpp
#include <types.h>      //Taken from DM_VPG

//
// our standard typedefs

#ifndef NULL
#define NULL 0
#endif

//Make Visual Studio happy
/*
#ifndef INT32
typedef signed long  INT32;
#endif
*/

#ifndef INT16
typedef signed short INT16;
#endif

#ifndef INT8
typedef signed char  INT8;
#endif

//Make Visual Studio happy
/*
#ifndef UINT32
typedef unsigned long  UINT32;
#endif
*/

#ifndef UINT16
typedef unsigned short UINT16;
#endif

#ifndef UINT8
typedef unsigned char  UINT8;
#endif

#ifndef BOOL
    #ifdef DMCARDS_BUILD
    typedef unsigned char BOOL;
    #else
    typedef int BOOL;
    #endif
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef ON
#define ON 1
#endif

#ifndef OFF
#define OFF 0
#endif

#ifndef BYTE
typedef unsigned char		BYTE;	/*  8 bits */
#endif

#ifndef WORD
typedef unsigned short	 	WORD;	/* 16 bits */
#endif

#ifndef U32
typedef unsigned long U32;
#endif

#else   //DM_CARDS_BUILD or Nucleus

//
// our standard typedefs

#ifndef NULL
#define NULL 0
#endif

#ifndef INT32
typedef signed long  INT32;
#endif

#ifndef INT16
typedef signed short INT16;
#endif

#ifndef INT8
typedef signed char  INT8;
#endif

#ifndef UINT32
typedef unsigned long  UINT32;
#endif

#ifndef UINT16
typedef unsigned short UINT16;
#endif

#ifndef UINT8
typedef unsigned char  UINT8;
#endif

#ifndef BOOL
    #ifdef DMCARDS_BUILD
    typedef unsigned char BOOL;
    #else
    typedef int BOOL;
    #endif
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef ON
#define ON 1
#endif

#ifndef OFF
#define OFF 0
#endif

#ifndef BYTE
typedef unsigned char		BYTE;	/*  8 bits */
#endif

#ifndef WORD
typedef unsigned short	 	WORD;	/* 16 bits */
#endif

#endif // DM_VPG

#ifndef DM_LIBRARY_DEBOUNCE_DISABLED
#define DM_LIBRARY_DEBOUNCE_DISABLED    -1
#endif

#define MAKEUINT16(l, h)     ((UINT16)(((UINT8)(l)) | ((UINT16)((UINT8)(h))) << 8))
#define MAKEUINT32(l, h)     ((UINT32)(((UINT16)(l)) | ((UINT32)((UINT16)(h))) << 16))
#define HIUINT16(l)          ((UINT16)(((UINT32)(l) >> 16) & 0xFFFF))
#define LOUINT16(l)          ((UINT16)(l))
#define HIUINT8(w)           ((UINT8)(((UINT16)(w) >> 8) & 0xff))
#define LOUINT8(w)           ((UINT8)(UINT16)(w))

// macros to handle endian conversions:

extern UINT16 Swap16(UINT16 sval);
extern UINT32 Swap32(UINT32 sval);

//Cresnet packets are little endian
//EDID serial # is big endian
//Create macros that perform conversion according to native endian-ness
#if defined(LITTLE_ENDIAN)
  //Native is little endian so create macros accordingly
  #define BE2NATIVE32(a)    Swap32(a)
  #define BE2NATIVE16(a)    Swap16(a)
  #define LE2NATIVE32(a)    (a)
  #define LE2NATIVE16(a)    (a)

  #define NATIVE2LE32(a)    (a)
  #define NATIVE2LE16(a)    (a)
  #define NATIVE2BE32(a)    Swap32(a)
  #define NATIVE2BE16(a)    Swap16(a)
#else
  //Native is big endian so create macros accordingly
  #define BE2NATIVE32(a)    (a)
  #define BE2NATIVE16(a)    (a)
  #define LE2NATIVE32(a)    Swap32(a)
  #define LE2NATIVE16(a)    Swap16(a)

  #define NATIVE2LE32(a)    Swap32(a)
  #define NATIVE2LE16(a)    Swap16(a)
  #define NATIVE2BE32(a)    (a)
  #define NATIVE2BE16(a)    (a)
#endif

#define BE2LE16(a)        ((a<<8)|(a>>8))
#define LE2BE16(a)        ((a<<8)|(a>>8))

//Macro to calculate array size
#ifndef NUM_OF
#define NUM_OF(a) (sizeof (a) / sizeof *(a))
#endif

#if !defined(DM_LINUX)
//Macros to calculate min/max
#ifndef min
#define min(x,y) (((x) < (y) ) ? (x) : (y))
#endif

#ifndef max
#define max(x,y) (((x) < (y) ) ? (y) : (x))
#endif

#endif //DM_LINUX

#ifdef __cplusplus
}
#endif

#endif
